--px_ragdoll_sync.ms is for sync pose info of the max biped system with corresponding physX hulls. 
--Author : Hypark Piao
--Contact : hpiao@nvidia.com
--Copyright (C) 2008-2009 nVIDIA Corp.
--For conditions of distribution and use, see copyright notice in http://www.nvidia.com/PhysX.

--purpose: Call this in simulation step for ragdoll.
--details:   The way is to sync & update user selected Biped model's posture with hulls 
--             &joints representation in PhysX scene by traversing 3dMax Biped system's bone
--             system's hierarchically and assign the  corresponding rotation quaternion info to each bones.
--@param bipObj : the root node of a biped system.
--@return null

function sync_ragdoll bipObj = 
(
	if ( classOf(bipObj)!=Biped_Object )  do
	(
		format( "PhysX Error: the object is not the root of a biped!" )
		false
	)
	else
	(
		--get the pelvis node
		local bipPelvis = biped.getNode bipObj #pelvis
		if bipPelvis!=undefined do
		(	
			modRB = PxGetModRB bipPelvis
			if modRB != undefined do
			(
				if modRB.type == PX_PHYSTYPE_DYNAMIC do
				(
					local mPose = nvpx.GetBonePose bipPelvis
					biped.setTransform bipObj #pos mPose.translationpart true
					
					-- -DH: added these because they seem like they should be here but everything goes crazy instead, 
					-- -so maybe the system respects pelvis rotation and scale but not position
					-- biped.setTransform bipObj #rotation  mPose.rotationpart  false
					-- biped.setTransform bipObj #scale mPose.scalepart   false
				)
			)
		)
		true
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBUZJ6+MrvFy/lts2LKVO2tfPgnN48EHk7y
-- OrOk3rL8Chzu3XGb6rOagZ3M8w4pQ99V63hm1LyvdrCDm/O16AmKAUBFWc6+46wh
-- ROA/7AQT0yzJADJ0UGEOuxLbBIDq3tK9vXgyC1ox2QdFLPm6PNWSllmSazcxpKln
-- 4VnfOF+KtMba5WHRSVkCYmVkf9E/4rcI57h/Y2gY1GsKkCmbHL6fRtq+fzV6DbPp
-- Erggui2TkoJj5k8K7sb3jjELn7qk/QwB8xivSP0P4qF5OLzSaFAz08syaqj09F7g
-- KrL5t9yciPgClM484AEFJySw70h54OIU+FgcOJireloktHYoZ33v
-- -----END-SIGNATURE-----